<?php
require 'includes/auth_check.php';
$claveBuscar = $_GET['clave'] ?? null;
if (!$claveBuscar) {
    die("Clave secreta requerida.");
}
$dsn = "mysql:host=localhost;dbname=laboratorio;charset=utf8mb4";
$dbUser = "root";
$dbPass = "";

try {
    $pdo = new PDO($dsn, $dbUser, $dbPass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT url_pdf, nombre_pdf FROM archivos_pdf WHERE clave_secreta = :clave_secreta LIMIT 1");
    $stmt->execute([':clave_secreta' => $claveBuscar]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        die("Clave secreta no encontrada.");
    }
} catch (PDOException $e) {
    die("Error base de datos: " . $e->getMessage());
}
$pdfPath = $row['url_pdf']; 

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <title>Visualización PDF - <?= htmlspecialchars($row['nombre_pdf']) ?></title>
    <style>
        body, html { margin:0; height:100%; }
        iframe { border:none; width:100%; height:100vh; }
    </style>
</head>
<body>
    <iframe src="<?= htmlspecialchars($pdfPath) ?>"></iframe>
</body>
</html>
