<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

if (isset($_SESSION['usuario'])) {
    header('Location: index.php');
    exit;
}

include('includes/config.php');
$usuario_value = '';
$password_value = '';
$keep_username = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $usuario = $_POST['usuario'];
    $pass = $_POST['pass'];
    $sql = "SELECT * FROM usuarios WHERE usuario = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $usuario);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();
        if (password_verify($pass, $user_data['pass'])) {
            $_SESSION['usuario'] = $usuario;
            $_SESSION['usuario_id'] = $user_data['id'];
            $_SESSION['rol'] = $user_data['rol'];

            $_SESSION['alert'] = [
                'type' => 'success',
                'title' => '¡Bienvenido!',
                'message' => 'Inicio de sesión exitoso'
            ];
            header('Location: index.php');
            exit;
        } else {
            $_SESSION['alert'] = [
                'type' => 'error',
                'title' => 'Error',
                'message' => 'Contraseña incorrecta'
            ];
            $usuario_value = htmlspecialchars($usuario);
            $keep_username = true;
        }
    } else {
        $_SESSION['alert'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'Usuario no encontrado'
        ];
        $usuario_value = '';
        $password_value = '';
    }
    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Login | InfoLab</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="assets/css/login.css" />
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <div class="wrapper">
        <form method="POST" action="login.php">
            <h2>Ingreso</h2>
            <div class="input-field">
                <input type="text" name="usuario" id="usuario" value="<?php echo $usuario_value; ?>" required />
                <label for="usuario" class="<?php echo !empty($usuario_value) ? 'active' : ''; ?>">Usuario</label>
            </div>

            <div class="input-field">
                <input
                  type="password"
                  name="pass"
                  id="pass"
                  value="<?php echo $password_value; ?>"
                  required
                />
                <label for="pass" class="<?php echo !empty($password_value) ? 'active' : ''; ?>">Contraseña</label>
                <span class="toggle-password" id="togglePassword">
                    <i class="bx bx-hide"></i>
                </span>
            </div>
            <br /><br /><br />
            <button type="submit">Ingresar</button>
        </form>
    </div>

    <script>
      document.getElementById('togglePassword').addEventListener('click', function () {
        const password = document.getElementById('pass');
        const icon = this.querySelector('i');
        if (password.type === 'password') {
          password.type = 'text';
          icon.classList.replace('bx-hide', 'bx-show');
        } else {
          password.type = 'password';
          icon.classList.replace('bx-show', 'bx-hide');
        }
      });

      <?php if (isset($_SESSION['alert'])): ?>
      Swal.fire({
        icon: '<?php echo $_SESSION['alert']['type']; ?>',
        title: '<?php echo $_SESSION['alert']['title']; ?>',
        text: '<?php echo $_SESSION['alert']['message']; ?>',
        confirmButtonColor: '#363A5E',
      }).then(() => {
        <?php if ($keep_username): ?>
          document.getElementById('pass').focus();
        <?php else: ?>
          document.getElementById('usuario').focus();
        <?php endif; ?>
      });
      <?php unset($_SESSION['alert']); endif; ?>
    </script>
</body>
</html>
