<?php include 'includes/auth_check.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Inicio</title>
  <link rel="icon" href="assets/images/logo.png" type="image/png"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" />
  <style>
    body, html {
      height: 100%;
      margin: 0;
    }
    .stat-card {
      border-radius: 15px;
      padding: 20px;
      color: white;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.3s;
    }
    .stat-card:hover {
      transform: translateY(-5px);
    }
    .users-card {
      background: linear-gradient(135deg, #3a7bd5, #00d2ff);
    }
    .documents-card {
      background: linear-gradient(135deg, #11998e, #38ef7d);
    }
  .chart-container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin: 30px auto 0;
            height: 700px;
            width: 55%;
            max-width: 1200px;
            overflow: auto;
        }
        @media (max-width: 768px) {
            .chart-container {
                overflow-x: scroll;
            }
        }
    .filter-container {
      background-color: white;
      border-radius: 15px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      padding: 20px;
      margin-bottom: 20px;
    }
    .dashboard-title {
      color: #333;
      font-weight: 700;
      margin-bottom: 30px;
    }
  </style>
</head>
<body>
<div id="app-container" class="expanded">
  <?php include 'includes/sidebar.php'; ?>
  
  <div class="container-fluid py-4">
    <h1 class="dashboard-title text-center">Dashboard Estadístico</h1>
    
    <div class="row filter-container">
      <div class="col-md-6">
        <label for="yearFilter" class="form-label">Filtrar por año:</label>
        <select class="form-select" id="yearFilter">
          <?php
          $currentYear = date('Y');
          for ($year = 2025; $year <= $currentYear; $year++) {
              $selected = ($year == $currentYear) ? 'selected' : '';
              echo "<option value='$year' $selected>$year</option>";
          }
          ?>
        </select>
      </div>
      <div class="col-md-6">
        <label for="monthFilter" class="form-label">Filtrar por mes:</label>
        <select class="form-select" id="monthFilter">
          <option value="all" selected>Todos los meses</option>
          <?php
          $year = date('Y');
          $monthlyCounts = array_fill(0, 12, 0);
          require_once 'includes/config.php'; 

          $query = "SELECT MONTH(fecha_subida) as month, COUNT(*) as count 
                    FROM archivos_pdf
                    WHERE YEAR(fecha_subida) = $year
                    GROUP BY MONTH(fecha_subida)";
          $result = $conn->query($query);
          if (!$result) {
              die("Error en la consulta: " . $conn->error); 
          }
          while ($row = $result->fetch_assoc()) {
              $monthlyCounts[$row['month'] - 1] = $row['count'];
          }
          
          $months = [
              1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
              5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
              9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
          ];
          foreach ($months as $num => $name) {
              echo "<option value='$num'>$name</option>";
          }
          ?>
        </select>
      </div>
    </div>
    <div class="row mb-4">
      <div class="col-md-6 mb-3 mb-md-0">
        <div class="stat-card users-card">
          <h3>Total de Usuarios</h3>
          <h1 class="display-4 fw-bold"><?php 
              require_once 'includes/config.php';
              $query = "SELECT COUNT(*) as total FROM usuarios";
              $result = $conn->query($query);
              if (!$result) {
                  die("Error en la consulta: " . $conn->error); 
              }
              $row = $result->fetch_assoc();
              $totalUsuarios = $row['total'];
              echo $totalUsuarios;
          ?></h1>
          <p class="mb-0">Usuarios registrados</p>
        </div>
      </div>
      <div class="col-md-6">
        <div class="stat-card documents-card">
          <h3>Total de Documentos</h3>
          <h1 class="display-4 fw-bold"><?php 
              $query = "SELECT COUNT(*) as total FROM archivos_pdf";
              $result = $conn->query($query);
              if (!$result) {
                  die("Error en la consulta: " . $conn->error); 
              }
              $row = $result->fetch_assoc();
              $totalDocumentos = $row['total'];
              echo $totalDocumentos;
          ?></h1>
          <p class="mb-0">Documentos subidos</p>
        </div>
      </div>
    </div>

      <div class="chart-container">
      <h4 class="mb-3">Documentos subidos por mes</h4>
      <div style="position: relative; height: 400px; min-width: 800px">
        <canvas id="documentsChart"></canvas>
      </div>
  </div>
</div>



<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="assets/js/sidebar.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    let documentsChart;
    const ctx = document.getElementById('documentsChart').getContext('2d');
    const monthLabels = <?php echo json_encode([
        'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 
        'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
    ]); ?>;
    const initialCounts = <?php echo json_encode($monthlyCounts); ?>;
    function initChart() {
        documentsChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'Documentos subidos',
                    data: initialCounts,
                    backgroundColor: Array(12).fill('rgba(54, 162, 235, 0.7)'),
                    borderColor: Array(12).fill('rgba(54, 162, 235, 1)'),
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        suggestedMax: 10, 
                        title: {
                            display: true,
                            text: 'Cantidad de documentos'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Meses del año'
                        }
                    }
                }
            }
        });
        filterData();
    }

    async function filterData() {
        const year = document.getElementById('yearFilter').value;
        const month = document.getElementById('monthFilter').value;
        
        try {
            const response = await fetch(`get_stats.php?year=${year}&month=${month}`);
            if (!response.ok) throw new Error('Network response was not ok');
            
            const data = await response.json();
            
            documentsChart.data.datasets[0].data = data.monthlyCounts;
            const maxCount = Math.max(...data.monthlyCounts);
            documentsChart.options.scales.y.suggestedMax = maxCount > 0 ? Math.ceil(maxCount * 1.2) : 10;
            documentsChart.update();
            
            document.querySelector('.users-card h1').textContent = data.totalUsers;
            document.querySelector('.documents-card h1').textContent = data.totalDocuments;
            
        } catch (error) {
            console.error('Error fetching data:', error);
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        initChart();
        
        document.getElementById('yearFilter').addEventListener('change', filterData);
        document.getElementById('monthFilter').addEventListener('change', filterData);
    });
</script>
</body>
</html>
