<?php
$sidebarHeaderImage = 'http://localhost/laboratorio/assets/images/logo.png'; 
$sidebarItems = [
      [
        'id' => 'inicio',
        'label' => 'Inicio',
        'image' => 'http://localhost/laboratorio/assets/images/inicio.png', 
        'url' => 'index.php'
    ],
    [
        'id' => 'qr',
        'label' => 'Generar QR',
        'image' => 'http://localhost/laboratorio/assets/images/qr.png', 
        'url' => 'qr.php'
    ],
    [
        'id' => 'vista',
        'label' => 'Visualizar Archivos',
        'image' => 'http://localhost/laboratorio/assets/images/visualizar.png', 
        'alt' => 'Icono de vista',
        'url' => 'informe.php'
    ],
    [
        'id' => 'usuario',
        'label' => 'Crear Usuario',
        'image' => 'http://localhost/laboratorio/assets/images/usuario.png',
        'alt' => 'Icono de usuario',
        'url' => 'usuario.php'
    ],

];
$exitImage = 'http://localhost/laboratorio/assets/images/salir.png'; 
?>
<nav id="sidebar" class="expanded" aria-label="Navegación lateral">
  <header id="sidebar-header">
    <img src="<?= htmlspecialchars($sidebarHeaderImage) ?>" alt="Logo cabecera sidebar" class="sidebar-logo" />
    <h1 class="sidebar-title" tabindex="0">LabInfo</h1>
    <button class="toggle-btn" id="sidebar-toggle" aria-label="Expandir o contraer barra lateral" title="Expandir o contraer barra lateral" tabindex="0">
      <span class="material-icons">chevron_left</span>
    </button>
  </header>
  <nav id="sidebar-nav" role="navigation" aria-label="Menú principal sidebar">
    <ul>
      <?php foreach ($sidebarItems as $item) : ?>
        <li>
          <a href="<?= htmlspecialchars($item['url']) ?>" tabindex="0">
            <img src="<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['alt']) ?>" class="item-image" loading="lazy" />
            <span class="item-label"><?= htmlspecialchars($item['label']) ?></span>
          </a>
        </li>
      <?php endforeach; ?>
    </ul>
  </nav>
  <footer id="sidebar-footer">
    <button id="exit-btn" type="button" aria-label="Salir de la aplicación" title="Salir de la aplicación" tabindex="0" class="exit-button">
      <img src="<?= htmlspecialchars($exitImage) ?>" alt="Icono de salir" class="exit-image" loading="lazy" />
      <span class="item-label">Salir</span>
    </button>
  </footer>
</nav>
